IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Eventos_Canje_Clientes_Sincronizar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Eventos_Canje_Clientes_Sincronizar
END
GO

CREATE PROCEDURE dbo.CPJ_Eventos_Canje_Clientes_Sincronizar @pJsonRecibido VARCHAR(MAX)
AS
SET NOCOUNT ON

	/***************************************************************************************************

	Procedimiento:      CPJ_Eventos_Canje_Clientes_Sincronizar
	Fecha de Creacion:  2024-02-07
	Creado por:         Adriana Laverde
	Descripcion:        Stored creado para validar sincronizacion de canjes online
	Llamado por:        kiosk/canje/ver.php
	Tablas afectadas:   z_eventos_clientes
	Usado en:           
	Parametro(s):       FlagUsarTrans, ModoDebug, Id, Id_Evento, Id_Cliente, Doc_Nro, Email, Flag_Sincronizado, Flag_Email, Id_Sector, Id_Lista_Evento, Fecha
	Forma de uso:       EXEC CPJ_Eventos_Canje_Clientes_Sincronizar '{"FlagUsarTrans":"0","ModoDebug":"0","Id":"0","Id_Evento":"0","Id_Cliente":"1","Doc_Nro":"0","Email":"","Flag_Sincronizado":"0","Flag_Email":"0";"Id_Sector":"0","Id_Lista_Evento":"0","Fecha","20240101"}'
	Notas adicionales:  

	****************************************************************************************************

	SUMARIO DE CAMBIOS
	FECHA(yyyy-mm-dd)    Autor              Comentarios
	------------------- ------------------- ------------------------------------------------------------

              
	***************************************************************************************************/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE	@pFlagUsarTrans			TINYINT,
		@pModoDebug				TINYINT,
		@pId					INT,
		@pId_Evento				INT,
		@pId_Lista_Evento		SMALLINT,
		@pId_Cliente			INT,
		@pDoc_Nro				VARCHAR(100),
		@pEmail					VARCHAR(100),
		@pFlag_Sincronizado		SMALLINT,
		@pFlag_Email			SMALLINT,
		@pId_Sector				SMALLINT,
		@pFecha					DATETIME

SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)
SET @pId					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id')), 0)
SET @pId_Evento				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Evento')), 0)
SET @pId_Lista_Evento		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Lista_Evento')),0)
SET @pId_Cliente			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Cliente')),0)
SET @pDoc_Nro				= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJsonRecibido,'Doc_Nro')),'')
SET @pEmail					= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJsonRecibido,'Email')),'')
SET @pFlag_Sincronizado		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Sincronizado')),0)
SET @pFlag_Email			= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Email')),0)
SET @pId_Sector				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Sector')),0)
SET @pFecha					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha')),'')
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored						INT
DECLARE @rtaMsjStored						VARCHAR(4000)
DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)
DECLARE @rta_JSON_Stored_Invocado			VARCHAR(8000)
DECLARE @Result_Stored_Invocado				INT
DECLARE @Result_Tabla_Stored_Invocado		TABLE (ErrorNumber	INT,
											ErrorSeverity	INT,
											ErrorState		INT,
											ErrorProcedure  VARCHAR(1000),
											ErrorLine		INT,
											ErrorMessage	VARCHAR(4000))
DECLARE @json								VARCHAR(8000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion Variables Locales*/	
DECLARE @Contrato							INT
DECLARE @Id_Trans							INT
DECLARE @Id_Trans_Origen					INT
DECLARE @Respuesta_Json						VARCHAR(4000)
DECLARE @Id_Cliente							INT
DECLARE @Fecha_QA							DATETIME
DECLARE @Importe							DECIMAL(12,2)
DECLARE @Id_Producto						VARCHAR(14)
DECLARE @Lote								VARCHAR(20)
DECLARE @Id_Tipo_Cbte						CHAR(4)
DECLARE @Fecha								DATETIME
DECLARE @Fecha_Actual						DATETIME
DECLARE @Sincronizado						SMALLINT = 0
DECLARE @Existe								SMALLINT
/*Fin de Declaraciones Variables Locales */

BEGIN TRY
	IF (@pFlagUsarTrans <> 0)
	BEGIN
		BEGIN TRAN
	END

	IF (@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Eventos_Canje_Clientes_Sincronizar'
		PRINT 'Parametros: '+ @pJsonRecibido  
		PRINT ' ---------------------- '
	END

	IF (@pId_Cliente = 0)
	BEGIN
		SELECT  5001 AS ErrorNumber
			,1 AS ErrorSeverity
			,1 AS ErrorState
			,1 AS ErrorProcedure
			,1 AS ErrorLine
			,'Id_Cliente en cero' AS ErrorMessage
		RETURN 9999
	END

	SET @Existe			= ISNULL((SELECT TOP 1 1 FROM z_eventos_clientes WHERE Id_Cliente = @pId_Cliente AND Flag_Sincronizado = 1 AND Id_Sector = @pId_Sector AND (id_evento = @pId_Lista_Evento OR id_evento = @pId_Evento)),0)
	SET @Id_Tipo_Cbte	= ISNULL((SELECT DBO.CF_xParam('Tipo_Cbte_VW_Pedido')), 'ND')
	SET @Fecha_Actual = CONVERT(VARCHAR(8), GETDATE(), 112)
	SET @Lote = 'ImportCanje_' + REPLACE(CONVERT(VARCHAR(10), @Fecha_Actual, 120), '-', '')


	SELECT @Fecha = Fecha_Evento
	FROM Prod_Listas_Precios 
	WHERE Id_Lista_Precio = @pId_Lista_Evento

	IF (@pModoDebug = 1)
	BEGIN
		PRINT 'Id_Producto: '+ CONVERT(VARCHAR(14),@Id_Producto)
		PRINT 'Id_Tipo_Cbte: '+ CONVERT(VARCHAR(14),@Id_Tipo_Cbte)
		PRINT 'Lote: '+ CONVERT(VARCHAR(20),@Lote)
		PRINT ' ---------------------- '
	END 
		

	IF (@Existe = 0)
	BEGIN
		INSERT INTO z_eventos_clientes (id,		id_evento,		id_cliente,		doc_nro,	email,			fecha,		flag_email,		flag_sincronizado,		id_sector) 
								VALUES (@pId,	@pId_Evento,	@pId_Cliente,	@pDoc_Nro,	@pEmail,	@pFecha,	@pFlag_Email,	@pFlag_Sincronizado,	@pId_Sector)


		IF (@Id_Tipo_Cbte <> '' AND @pId_Lista_Evento > 0)
		BEGIN

			DECLARE curUCPCarga CURSOR FOR
			SELECT TOP 1 Z.Id_Cliente, @Fecha, 0, 0, 0, P.Id_Producto 
			FROM z_eventos_clientes Z, Empresas_Sedes_Sectores S, Productos P
			WHERE Z.Id_Sector	= S.Id_Sector
			AND S.Id_Sector		= P.Id_Sector
			AND Z.Id_Cliente	= @pId_Cliente
			AND P.Activo		= 1
			AND S.Flag_Ubic_Fija = 0
			AND Z.Id_Evento = @pId_Evento
			AND Z.Flag_Sincronizado = 0

			OPEN curUCPCarga
			FETCH NEXT FROM curUCPCarga INTO  @Id_Cliente, @Fecha_QA, @Importe, @Contrato, @Id_Trans_Origen, @Id_Producto
			WHILE @@FETCH_STATUS = 0
			BEGIN


			SET @json =	'{'
				SET @json =	@json + '"FlagUsarTrans":"0"'
				SET @json =	@json +	',"ModoDebug":"0"'
				SET @json =	@json +	',"Id_Usuario":"-1"'
				SET @json =	@json +	',"Lote":"' + CONVERT(VARCHAR(20), @Lote) +'"'
				SET @json =	@json +	',"Fecha":"' + CONVERT(VARCHAR(10), GETDATE(), 112) +'"'
				SET @json =	@json +	',"FechaVence":"' + CONVERT(VARCHAR(10), GETDATE(), 112) +'"'
				SET @json =	@json +	',"Id_Cliente":"' + CONVERT(VARCHAR(10), @Id_Cliente) +'"'
				SET @json =	@json +	',"Id_Tipo_Cbte":"' + CONVERT(VARCHAR(4), @Id_Tipo_Cbte) +'"'
				SET @json =	@json +	',"Id_Cond_Pago":"10"'
				SET @json =	@json +	',"Id_Lista_Precio":"' + CONVERT(VARCHAR(4), @pId_Lista_Evento) +'"'
				SET @json =	@json +	',"Id_Moneda":"PES"'
				SET @json =	@json +	',"Refacturar":"1"'
				SET @json =	@json +	',"Cotizacion":"1"'
				SET @json =	@json +	'}'

				SET @Id_Trans = 0
				DELETE @Result_Tabla_Stored_Invocado
	
				INSERT INTO @Result_Tabla_Stored_Invocado  
				EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Ped_Generar @json

				IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
				BEGIN
					RAISERROR ('Error when calling CPJ_Cbtes_Ped_Generar', 16,  1 ) 
				END
				ELSE
				BEGIN
					SELECT TOP 1 @rta_JSON_Stored_Invocado = ErrorMessage FROM @Result_Tabla_Stored_Invocado
					SET @Id_Trans = ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@rta_JSON_Stored_Invocado,'Id_Trans')), 0)
				END

				IF(@Id_Trans > 0)
				BEGIN
					SET @json =	'{'
					SET @json =	@json + '"FlagUsarTrans":"0"'
					SET @json =	@json +	',"ModoDebug":"0"'
					SET @json =	@json +	',"Lote":"' + CONVERT(VARCHAR(20), @Lote) +'"'
					SET @json =	@json +	',"Refacturar":"1"'
					SET @json =	@json +	',"Bonif":"0"'
					SET @json =	@json +	',"Id_Trans":"' + CONVERT(VARCHAR(10), @Id_Trans) +'"'
					SET @json =	@json +	',"Id_Cliente":"' + CONVERT(VARCHAR(10), @Id_Cliente) +'"'
					SET @json =	@json +	',"Id_Producto":"' + CONVERT(VARCHAR(10), @Id_Producto) +'"'
					SET @json =	@json +	',"Cantidad":"' + CONVERT(VARCHAR(10), 1) +'"'
					SET @json =	@json +	',"Precio_Grav":"' + CONVERT(VARCHAR(10), @Importe) +'"'
					SET @json =	@json +	',"Fecha_QA":"' + CONVERT(VARCHAR(10), @Fecha_QA, 112) +'"'
					SET @json =	@json +	',"Fecha_Venc":"' + CONVERT(VARCHAR(10), @Fecha_QA, 112) +'"'
					SET @json =	@json +	'}'

					DELETE @Result_Tabla_Stored_Invocado
	
					INSERT INTO @Result_Tabla_Stored_Invocado 
					EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Ped_Generar_Item @json

					IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
					BEGIN
						RAISERROR ('Error when calling CPJ_Cbtes_Ped_Generar_Item', 16,  1 ) 
					END
				END

				IF(@Id_Trans > 0)
				BEGIN
					SET @json =	'{'
					SET @json =	@json + '"FlagUsarTrans":"0"'
					SET @json =	@json +	',"ModoDebug":"0"'
					SET @json =	@json +	',"Id_Trans":"' + CONVERT(VARCHAR(10), @Id_Trans) +'"'
					SET @json =	@json +	'}'

					DELETE @Result_Tabla_Stored_Invocado
	
					INSERT INTO @Result_Tabla_Stored_Invocado 
					EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Ped_Fin @json

		

					IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
					BEGIN
						RAISERROR ('Error when calling CPJ_Cbtes_Ped_Fin', 16,  1 ) 
					END
				END

				IF(@Id_Trans > 0)
				BEGIN
					UPDATE z_eventos_clientes SET Flag_Sincronizado = 1 WHERE Id_Cliente = @pId_Cliente AND Id = @pId
					--Aqui disparar mail
				END

			FETCH NEXT FROM curUCPCarga INTO  @Id_Cliente, @Fecha_QA, @Importe, @Contrato, @Id_Trans_Origen, @Id_Producto
			END
			CLOSE curUCPCarga
			DEALLOCATE curUCPCarga;

		END

		SET @Sincronizado = ISNULL((SELECT TOP 1 1 FROM z_eventos_clientes WHERE Id_Evento = @pId_Evento AND Id_Cliente = @pId_Cliente),0)

	END
	ELSE
	BEGIN
		SET @Sincronizado = 1

		IF (@pModoDebug = 1)
		BEGIN
			PRINT 'Id_Cliente ya sincronizado'
			PRINT ' ---------------------- '
		END 
	END

	/*========================================================= RESULTADO =======================================================================================*/

		IF (@Sincronizado = 1)
		BEGIN
			SELECT @pId_Cliente AS 'Id_Cliente'
		END
		ELSE
		BEGIN
			SELECT 0 AS 'Error'
		END
	
	/*====================================================================================================================================================*/

	IF @pFlagUsarTrans <> 0 COMMIT
	
	/*====================================================================================================================================================*/

	IF (@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Eventos_Canje_Clientes_Sincronizar'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 